/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service.shutdown;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ShutdownService {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownService.class);
    private final ConfigurableApplicationContext applicationContext;

    public ShutdownService(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void shutdown() {
        try {
            logger.info("Try to terminate spring boot application.");
            int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
            logger.info("Spring boot exit code: {}", (Object)exitCode);
            System.exit(exitCode);
        }
        catch (Exception e) {
            logger.error("Can not terminate spring boot application.", (Throwable)e);
        }
    }
}

