/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.service.token;

import com.google.gson.Gson;
import de.mahlsdorf.groupservice.model.node.Tool;
import de.mahlsdorf.groupservice.neodb.Neo4JBaseService;
import de.mahlsdorf.lti13.advantage.service.jwks.JwksService;
import de.mahlsdorf.lti13.advantage.service.security.AccessTokenStore;
import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import de.mahlsdorf.lti13.lti13models.model.Lti13AccessToken;
import io.fusionauth.jwt.JWTUtils;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.rsa.RSAVerifier;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;

@Service
public class TokenService {
    private static final Logger logger = LoggerFactory.getLogger(TokenService.class);
    private static final String NL = "\n";
    private final Map<String, Lti13AccessToken> accessTokenMap = new HashMap();
    private JwksService jwksService;
    private AccessTokenStore accessTokenStore;
    private Neo4JBaseService neo4JBaseService;

    public TokenService(@Autowired Neo4JBaseService neo4JBaseService) {
        this.neo4JBaseService = neo4JBaseService;
    }

    public String grantAccessToken(MultiValueMap<String, String> formData, String platformId) throws ApiLti13Exception {
        logger.info("try to validate AccessTokenRequest for PlatformId '{}'", (Object)platformId);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : formData.entrySet()) {
            sb.append((String)entry.getKey()).append(": ").append(entry.getValue() + NL);
        }
        logger.info("parameter AccessToken \n" + sb);
        logger.error("############################ VALIDATE the JWT Parameter with public Key ");
        String clientAssertation = (String)formData.getFirst((Object)"client_assertion");
        this.checkValiditySignatureJwt(clientAssertation, platformId);
        logger.info("TokenRequest for Access is valid clientAssertaion {} platfromId {}", (Object)clientAssertation, (Object)platformId);
        Lti13AccessToken accessToken = new Lti13AccessToken();
        accessToken.setExpiresIn(Long.valueOf(10L));
        String uuidString = UUID.randomUUID().toString();
        accessToken.setAccessTokenAsString(uuidString);
        accessToken.setTokenType("Bearer");
        accessToken.setScope("");
        this.accessTokenStore.putAccessToken(accessToken);
        this.accessTokenMap.put(uuidString, accessToken);
        logger.info("put AccessToken to Map key {} token {}", (Object)uuidString, (Object)accessToken);
        Gson gson = new Gson();
        String result = gson.toJson((Object)accessToken);
        logger.info("grant AccessToken {}", (Object)result);
        return result;
    }

    private void checkValiditySignatureJwt(String jwtClientAssertation, String toolId) throws ApiLti13Exception {
        try {
            logger.debug("try to validate jwt in tokenRequest ");
            Tool tool = (Tool)this.neo4JBaseService.getToolsById(toolId).get(0);
            String kid = JWTUtils.decodeHeader((String)jwtClientAssertation).get("kid");
            String publicKeyAsPem = this.jwksService.getPemFilePublicKey(tool, true, kid);
            logger.debug("got pem file {}", (Object)publicKeyAsPem);
            RSAVerifier verifier = RSAVerifier.newVerifier((String)publicKeyAsPem);
            JWT jwt = JWT.getDecoder().decode(jwtClientAssertation, new Verifier[]{verifier});
            logger.debug("JWT is {}", (Object)jwt);
        }
        catch (Exception e) {
            logger.error("Exception while decode JWT in TokenRequest ", (Throwable)e);
            throw new ApiLti13Exception(e.getMessage(), "ERROR", HttpStatus.UNAUTHORIZED);
        }
    }

    public boolean isTokenValid(String uuidString) {
        Lti13AccessToken token = (Lti13AccessToken)this.accessTokenMap.get(uuidString);
        if (token == null) {
            logger.info("no token found for token {}", (Object)uuidString);
        } else if (token.getValidUntil() * 1000L < System.currentTimeMillis()) {
            logger.info("token {} is expired {},", (Object)token, (Object)new Date(token.getValidUntil() * 1000L));
            return false;
        }
        return true;
    }

    @Autowired
    public void setJwksService(JwksService jwksService) {
        this.jwksService = jwksService;
    }

    @Autowired
    public void setAccessTokenStore(AccessTokenStore accessTokenStore) {
        this.accessTokenStore = accessTokenStore;
    }
}

