/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.util;

import jakarta.validation.constraints.NotNull;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DateHelper {
    public static final String ES_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss Z";
    public static final String TRACKING_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.mmm'Z'";
    public static final String DAY_ONLY_FORMAT = "yyyyMMdd";
    private static final DateFormat JSON_TRACKING_DATE_FORMAT;
    private static final DateFormat DAY_ONLY_DATE_FORMAT;
    private static final Pattern HOUR_PATTERN;
    private static final Pattern MINUTE_PATTERN;
    private static final Pattern SECOND_PATTERN;

    private DateHelper() {
    }

    public static int parseXapiTime(@NotNull String xapiTime) {
        xapiTime = xapiTime.toLowerCase().replaceAll("pt", "");
        int result = 0;
        if (xapiTime.contains("h")) {
            int hours = DateHelper.getNumberPart((Pattern)HOUR_PATTERN, (String)xapiTime);
            result = hours * 3600;
        }
        if (xapiTime.contains("m")) {
            int minutes = DateHelper.getNumberPart((Pattern)MINUTE_PATTERN, (String)xapiTime);
            result += minutes * 60;
        }
        if (xapiTime.contains("s")) {
            int seconds = DateHelper.getNumberPart((Pattern)SECOND_PATTERN, (String)xapiTime);
            result += seconds;
        }
        return result;
    }

    private static int getNumberPart(Pattern pattern, String xapiTime) {
        int result = 0;
        Matcher m = pattern.matcher(xapiTime);
        if (m.matches()) {
            result = Integer.parseInt(m.group(1));
        }
        return result;
    }

    public static String convertSecondsToXapiTime(@NotNull int seconds) {
        String result = "";
        StringBuilder sb = new StringBuilder();
        int rest = seconds;
        if (seconds > 3599) {
            int hours = seconds / 3600;
            rest = seconds % 3600;
            sb.append(hours + "h ");
        }
        if (rest > 60) {
            int minutes = rest / 60;
            rest %= 60;
            sb.append(minutes + "m ");
        }
        sb.append(rest + "s");
        return sb.toString();
    }

    static {
        HOUR_PATTERN = Pattern.compile(".*?(\\d+)h.*?");
        MINUTE_PATTERN = Pattern.compile(".*?(\\d+)m.*?");
        SECOND_PATTERN = Pattern.compile(".*?(\\d+)s.*?");
        JSON_TRACKING_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.mmm'Z'");
        JSON_TRACKING_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        DAY_ONLY_DATE_FORMAT = new SimpleDateFormat("yyyyMMdd");
        DAY_ONLY_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

