/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.advantage.util;

import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public final class FileHelper {
    private static final int CHUNK_SIZE = 10000;
    private static final Logger logger = LoggerFactory.getLogger(FileHelper.class);

    private FileHelper() {
    }

    public static String getContentFromClassPath(String pathName) throws IOException {
        try (InputStream is = FileHelper.class.getClassLoader().getResourceAsStream(pathName);){
            String string;
            ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
            try {
                IOUtils.copy((InputStream)is, (OutputStream)bos);
                string = bos.toString();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception c) {
                    logger.warn("Exception during reading of " + pathName + " ", (Throwable)c);
                    throw c;
                }
            }
            bos.close();
            return string;
        }
    }

    public static void writeUploadFileToDisk(MultipartFile multipartFile, String fileName) throws ApiLti13Exception {
    }

    public static void closeOutputStream(OutputStream fos) {
        if (fos != null) {
            try {
                fos.close();
            }
            catch (Exception e) {
                logger.warn("cant close fileoutput Stream ", (Throwable)e);
            }
        }
    }

    public static void closeInputStream(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (Exception e) {
                logger.warn("cant close inputStream ", (Throwable)e);
            }
        }
    }

    public static void writeFile(InputStream inputStream, OutputStream fos) throws IOException {
        boolean notReadedFully = true;
        while (notReadedFully) {
            byte[] myBytes = new byte[10000];
            int start = 0;
            int readedBytes = IOUtils.read((InputStream)inputStream, (byte[])myBytes, (int)start, (int)10000);
            if (readedBytes < 10000) {
                byte[] lastBytes = new byte[readedBytes];
                System.arraycopy(myBytes, 0, lastBytes, 0, readedBytes);
                myBytes = lastBytes;
                notReadedFully = false;
            }
            IOUtils.write((byte[])myBytes, (OutputStream)fos);
        }
    }
}

