/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.lti13models.model.lti.gateway;

import de.mahlsdorf.lti13.lti13models.model.lti.gateway.Lti13PlatformDefinition;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class Lti13PlatformDefinition
implements Serializable {
    private String platformKey;
    private String keyId;
    private String clientId;
    private String deploymentId;
    private String keysetUrl;
    private String oAuth2Url;
    private String oidcAuthUrl;
    private String myPrivateKeyForThisPlatformAsPem;
    private String myPublicKeyForThisPlatform;
    private String oidcLoginHttpMethod = "get";
    private String description;
    private String organisation;
    private String address;
    private String adminEmail;
    private Long modified = System.currentTimeMillis();
    private String modifiedAsString;
    private String modifiedBy;
    private String platformPublicKeyAsPem;
    private Boolean suppressWritingToLrs = false;
    private Boolean shownLicensedBooksOnly = false;
    private FederalCountry federalCountry = FederalCountry.DE_BE;
    private boolean writeActivityScoresToLms = false;
    private boolean isExternalCustomer = true;
    private LmsType lmsType = LmsType.MOODLE;
    private String issuer;

    public Lti13PlatformDefinition() {
    }

    public Lti13PlatformDefinition(String platformKey, String clientId, String keysetUrl, String oAuth2Url, String oidcAuthUrl, String method) {
        this.platformKey = platformKey;
        this.clientId = clientId;
        this.keysetUrl = keysetUrl;
        this.oAuth2Url = oAuth2Url;
        this.oidcAuthUrl = oidcAuthUrl;
        this.oidcLoginHttpMethod = method;
    }

    public String getPlatformKey() {
        return this.platformKey;
    }

    public void setPlatformKey(String platformKey) {
        this.platformKey = platformKey;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getKeysetUrl() {
        return this.keysetUrl;
    }

    public void setKeysetUrl(String keysetUrl) {
        this.keysetUrl = keysetUrl;
    }

    public String getoAuth2Url() {
        return this.oAuth2Url;
    }

    public void setoAuth2Url(String oAuth2Url) {
        this.oAuth2Url = oAuth2Url;
    }

    public String getOidcAuthUrl() {
        return this.oidcAuthUrl;
    }

    public void setOidcAuthUrl(String oidcAuthUrl) {
        this.oidcAuthUrl = oidcAuthUrl;
    }

    public String getMyPrivateKeyForThisPlatformAsPem() {
        return this.myPrivateKeyForThisPlatformAsPem;
    }

    public void setMyPrivateKeyForThisPlatformAsPem(String myPrivateKeyForThisPlatformAsPem) {
        this.myPrivateKeyForThisPlatformAsPem = myPrivateKeyForThisPlatformAsPem;
    }

    public String getMyPublicKeyForThisPlatform() {
        return this.myPublicKeyForThisPlatform;
    }

    public void setMyPublicKeyForThisPlatform(String myPublicKeyForThisPlatform) {
        this.myPublicKeyForThisPlatform = myPublicKeyForThisPlatform;
    }

    public String getOidcLoginHttpMethod() {
        return this.oidcLoginHttpMethod;
    }

    public void setOidcLoginHttpMethod(String oidcLoginHttpMethod) {
        this.oidcLoginHttpMethod = oidcLoginHttpMethod;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public void setOrganisation(String organisation) {
        this.organisation = organisation;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }

    public String getPlatformPublicKeyAsPem() {
        return this.platformPublicKeyAsPem;
    }

    public void setPlatformPublicKeyAsPem(String platformPubicKeyAsPem) {
        this.platformPublicKeyAsPem = platformPubicKeyAsPem;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    public Long getModified() {
        return this.modified;
    }

    public void setModified(Long modified) {
        this.modified = modified;
    }

    public String getModifiedAsString() {
        return new Date(this.modified).toString();
    }

    public void setModifiedAsString(String modifiedAsString) {
        this.modifiedAsString = modifiedAsString;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Boolean getSuppressWritingToLrs() {
        return this.suppressWritingToLrs;
    }

    public void setSuppressWritingToLrs(Boolean suppressWritingToLrs) {
        this.suppressWritingToLrs = suppressWritingToLrs;
    }

    public Boolean getShownLicensedBooksOnly() {
        return this.shownLicensedBooksOnly;
    }

    public void setShownLicensedBooksOnly(boolean shownLicensedBooksOnly) {
        this.shownLicensedBooksOnly = shownLicensedBooksOnly;
    }

    public void setShownLicensedBooksOnly(Boolean shownLicensedBooksOnly) {
        this.shownLicensedBooksOnly = shownLicensedBooksOnly;
    }

    public boolean isWriteActivityScoresToLms() {
        return this.writeActivityScoresToLms;
    }

    public void setWriteActivityScoresToLms(boolean writeActivityScoresToLms) {
        this.writeActivityScoresToLms = writeActivityScoresToLms;
    }

    public FederalCountry getFederalCountry() {
        return this.federalCountry;
    }

    public void setFederalCountry(FederalCountry federalCountry) {
        this.federalCountry = federalCountry;
    }

    public boolean isExternalCustomer() {
        return this.isExternalCustomer;
    }

    public void setExternalCustomer(boolean externalCustomer) {
        this.isExternalCustomer = externalCustomer;
    }

    public LmsType getLmsType() {
        return this.lmsType;
    }

    public void setLmsType(LmsType lmsType) {
        this.lmsType = lmsType;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String toString() {
        return "PlatformDefinition{platformKey='" + this.platformKey + "', keyId='" + this.keyId + "', clientId='" + this.clientId + "', keysetUrl='" + this.keysetUrl + "', oAuth2Url='" + this.oAuth2Url + "', oidcAuthUrl='" + this.oidcAuthUrl + "', myPrivateKeyForThisPlatformAsPem='" + this.myPrivateKeyForThisPlatformAsPem + "', myPublicKeyForThisPlatform='" + this.myPublicKeyForThisPlatform + "', oidcLoginHttpMethod='" + this.oidcLoginHttpMethod + "', description='" + this.description + "', organisation='" + this.organisation + "', address='" + this.address + "', adminEmail='" + this.adminEmail + "', modified=" + this.modified + ", modifiedAsString='" + this.modifiedAsString + "', modifiedBy='" + this.modifiedBy + "', platformPublicKeyAsPem='" + this.platformPublicKeyAsPem + "', suppressWritingToLrs=" + this.suppressWritingToLrs + ", shownLicensedBooksOnly=" + this.shownLicensedBooksOnly + ", federalCountry=" + this.federalCountry + ", LmsType=" + this.lmsType + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Lti13PlatformDefinition)) {
            return false;
        }
        Lti13PlatformDefinition that = (Lti13PlatformDefinition)o;
        return Objects.equals(this.getPlatformKey(), that.getPlatformKey()) && Objects.equals(this.getClientId(), that.getClientId()) && Objects.equals(this.getKeysetUrl(), that.getKeysetUrl()) && Objects.equals(this.getoAuth2Url(), that.getoAuth2Url()) && Objects.equals(this.getOidcAuthUrl(), that.getOidcAuthUrl()) && Objects.equals(this.getMyPrivateKeyForThisPlatformAsPem(), that.getMyPrivateKeyForThisPlatformAsPem()) && Objects.equals(this.getMyPublicKeyForThisPlatform(), that.getMyPublicKeyForThisPlatform()) && Objects.equals(this.getOidcLoginHttpMethod(), that.getOidcLoginHttpMethod()) && Objects.equals(this.getDescription(), that.getDescription()) && Objects.equals(this.getOrganisation(), that.getOrganisation()) && Objects.equals(this.getAddress(), that.getAddress()) && Objects.equals(this.getAdminEmail(), that.getAdminEmail()) && Objects.equals(this.getPlatformPublicKeyAsPem(), that.getPlatformPublicKeyAsPem());
    }

    public int hashCode() {
        return Objects.hash(this.getPlatformKey(), this.getClientId(), this.getKeysetUrl(), this.getoAuth2Url(), this.getOidcAuthUrl(), this.getMyPrivateKeyForThisPlatformAsPem(), this.getMyPublicKeyForThisPlatform(), this.getOidcLoginHttpMethod(), this.getDescription(), this.getOrganisation(), this.getAddress(), this.getAdminEmail(), this.getPlatformPublicKeyAsPem());
    }
}

