/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13.tool.service.rest;

import de.mahlsdorf.lti13.exception.exception.ApiLti13Exception;
import jakarta.validation.constraints.NotNull;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RestService {
    public static final List<HttpStatus> OK_CODES = new ArrayList<HttpStatus>(Arrays.asList(HttpStatus.OK, HttpStatus.CREATED, HttpStatus.ACCEPTED));
    public static final List<HttpStatus> OK_REDIRECT = new ArrayList<HttpStatus>(Arrays.asList(HttpStatus.OK, HttpStatus.PERMANENT_REDIRECT, HttpStatus.CREATED, HttpStatus.FOUND, HttpStatus.MOVED_PERMANENTLY, HttpStatus.ACCEPTED));
    public static final List<HttpStatus> OK_CODES_AND_NOT_FOUND = new ArrayList<HttpStatus>(Arrays.asList(HttpStatus.OK, HttpStatus.CREATED, HttpStatus.NOT_FOUND));
    static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RestService.class);

    public static void checkErrorCodes(ResponseEntity<? extends Object> response, List<HttpStatus> okCodes) throws ApiLti13Exception {
        if (response.getStatusCode() == null || !okCodes.contains(response.getStatusCode())) {
            String message = String.format("ResponseCode != %s ResponseCode %s", okCodes, response.getStatusCode());
            logger.info(message);
            throw new ApiLti13Exception(message, "ERROR", HttpStatus.BAD_REQUEST);
        }
    }

    public static void handleException(Exception e, String txt, List<HttpStatus> okCodes) throws ApiLti13Exception {
        if (e instanceof HttpClientErrorException) {
            HttpClientErrorException he = (HttpClientErrorException)((Object)e);
            logger.info("Response is " + new String(((HttpClientErrorException)((Object)e)).getResponseBodyAsByteArray()));
            if (he.getRawStatusCode() == HttpStatus.NOT_FOUND.value() && okCodes.contains(HttpStatus.NOT_FOUND)) {
                logger.debug("returned statuscode 404 which is also valid");
                return;
            }
        }
        String message = String.format("unexpected Exception at %s Exception: %s", txt, e.getMessage());
        logger.warn(message, (Throwable)e);
        throw new ApiLti13Exception(message, "ERROR", HttpStatus.BAD_REQUEST);
    }

    public <T> T putOrPostDataJson(RestTemplate restTemplate, String urlPart, HttpMethod httpMethod, Class<T> type, Object body, List<HttpStatus> okCodes) throws ApiLti13Exception {
        try {
            URI apiUri = this.createApiUri(urlPart);
            logger.debug("putting Data Clazz {} URL {} ", (Object)body.getClass().getName(), (Object)apiUri.toURL());
            HttpHeaders headers = new HttpHeaders();
            headers.add((Object)"Content-Type", (Object)"application/json;charset=UTF-8");
            HttpEntity entity = new HttpEntity(body, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(apiUri, httpMethod, entity, type);
            RestService.checkErrorCodes((ResponseEntity)response, okCodes);
            return (T)response.getBody();
        }
        catch (Exception e) {
            logger.info("Exception while Put or Post Data ", (Throwable)e);
            RestService.handleException((Exception)e, (String)"at put data ", okCodes);
            return null;
        }
    }

    public <T> ResponseEntity<T> putOrPostDataFormData(RestTemplate restTemplate, String urlPart, HttpMethod httpMethod, Class<T> type, @NotNull MultiValueMap map, @NotNull List<HttpStatus> okCodes) throws ApiLti13Exception {
        try {
            URI apiUri = this.createApiUri(urlPart);
            logger.info("putting FormData {} URL {} ", (Object)map, (Object)apiUri.toURL());
            HttpHeaders headers = new HttpHeaders();
            HttpEntity entity = new HttpEntity((Object)map, (MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(apiUri, httpMethod, entity, type);
            RestService.checkErrorCodes((ResponseEntity)response, okCodes);
            logger.debug("Result {} ", response.getBody());
            return response;
        }
        catch (Exception e) {
            logger.info("Exception while Put or Post Data ", (Throwable)e);
            RestService.handleException((Exception)e, (String)"at put data ", okCodes);
            return null;
        }
    }

    public URI createApiUri(String urltoBeUsed) throws MalformedURLException, URISyntaxException {
        URL apiUrl = new URL(urltoBeUsed);
        return apiUrl.toURI();
    }
}

