/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.LTILinkResourceRefType;
import de.mahlsdorf.lti13rs.ltirs.model.MetadataType;
import de.mahlsdorf.lti13rs.ltirs.model.PlatformPropertySetType;
import de.mahlsdorf.lti13rs.ltirs.model.PropertySetType;
import de.mahlsdorf.lti13rs.ltirs.model.VendorType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="The extended set of information used to define the presence of an LTI Link resource (this is based upon the definition for including an LTI link inside an IMS Common Cartridge or IMS Thin Common Cartridge).")
public class CCLTILinkType
implements Serializable {
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="custom")
    private PropertySetType custom;
    @JsonProperty(value="extensions")
    private PlatformPropertySetType extensions;
    @JsonProperty(value="launch_url")
    private String launchUrl;
    @JsonProperty(value="secure_launch_url")
    private String secureLaunchUrl;
    @JsonProperty(value="icon")
    private URI icon;
    @JsonProperty(value="secure_icon")
    private URI secureIcon;
    @JsonProperty(value="vendor")
    private VendorType vendor;
    @JsonProperty(value="cartridge_bundle")
    private LTILinkResourceRefType cartridgeBundle;
    @JsonProperty(value="cartridge_icon")
    private LTILinkResourceRefType cartridgeIcon;
    @JsonProperty(value="metadata")
    private MetadataType metadata;

    public CCLTILinkType title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. The human readable title/label for the activity being addressed by the content available through the LTI link.")
    @NotNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CCLTILinkType description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = String. A human readable description of the activity addressed by the content supplied via the LTI link.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CCLTILinkType custom(PropertySetType custom) {
        this.custom = custom;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public PropertySetType getCustom() {
        return this.custom;
    }

    public void setCustom(PropertySetType custom) {
        this.custom = custom;
    }

    public CCLTILinkType extensions(PlatformPropertySetType extensions) {
        this.extensions = extensions;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public PlatformPropertySetType getExtensions() {
        return this.extensions;
    }

    public void setExtensions(PlatformPropertySetType extensions) {
        this.extensions = extensions;
    }

    public CCLTILinkType launchUrl(String launchUrl) {
        this.launchUrl = launchUrl;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. The URL for the LTI launch. One of either the launch_url or the secure_launch_url must be specified. It is acceptable to specify both and if both are specified, the Tool Consumer (TC) decides which to use. Typically, the TC will use a secure_launch_url when embedding the Tool in a secure page and the launch_url when embedding the tool in a non-secure page. So, it is important that the Tool Provider (TP) provides the same functionality whether the launch_url or secure_launch_url is used.")
    @Valid
    public String getLaunchUrl() {
        return this.launchUrl;
    }

    public void setLaunchUrl(String launchUrl) {
        this.launchUrl = launchUrl;
    }

    public CCLTILinkType secureLaunchUrl(String secureLaunchUrl) {
        this.secureLaunchUrl = secureLaunchUrl;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. A secure URL for the LTI launch. One of either the launch_url or the secure_launch_url must be specified. It is acceptable to specify both and if both are specified, the Tool Consumer (TC) decides which to use. Typically, the TC will use a secure_launch_url when embedding the Tool in a secure page and the launch_url when embedding the tool in a non-secure page. So, it is important that the Tool Provider (TP) provides the same functionality whether the launch_url or secure_launch_url is used.")
    @Valid
    public String getSecureLaunchUrl() {
        return this.secureLaunchUrl;
    }

    public void setSecureLaunchUrl(String secureLaunchUrl) {
        this.secureLaunchUrl = secureLaunchUrl;
    }

    public CCLTILinkType icon(URI icon) {
        this.icon = icon;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. A URL to an icon for this tool.")
    @Valid
    public URI getIcon() {
        return this.icon;
    }

    public void setIcon(URI icon) {
        this.icon = icon;
    }

    public CCLTILinkType secureIcon(URI secureIcon) {
        this.secureIcon = secureIcon;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. A secure URL to an icon for this tool.")
    @Valid
    public URI getSecureIcon() {
        return this.secureIcon;
    }

    public void setSecureIcon(URI secureIcon) {
        this.secureIcon = secureIcon;
    }

    public CCLTILinkType vendor(VendorType vendor) {
        this.vendor = vendor;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public VendorType getVendor() {
        return this.vendor;
    }

    public void setVendor(VendorType vendor) {
        this.vendor = vendor;
    }

    public CCLTILinkType cartridgeBundle(LTILinkResourceRefType cartridgeBundle) {
        this.cartridgeBundle = cartridgeBundle;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LTILinkResourceRefType getCartridgeBundle() {
        return this.cartridgeBundle;
    }

    public void setCartridgeBundle(LTILinkResourceRefType cartridgeBundle) {
        this.cartridgeBundle = cartridgeBundle;
    }

    public CCLTILinkType cartridgeIcon(LTILinkResourceRefType cartridgeIcon) {
        this.cartridgeIcon = cartridgeIcon;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LTILinkResourceRefType getCartridgeIcon() {
        return this.cartridgeIcon;
    }

    public void setCartridgeIcon(LTILinkResourceRefType cartridgeIcon) {
        this.cartridgeIcon = cartridgeIcon;
    }

    public CCLTILinkType metadata(MetadataType metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public MetadataType getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataType metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CCLTILinkType ccLTILinkType = (CCLTILinkType)o;
        return Objects.equals(this.title, ccLTILinkType.title) && Objects.equals(this.description, ccLTILinkType.description) && Objects.equals(this.custom, ccLTILinkType.custom) && Objects.equals(this.extensions, ccLTILinkType.extensions) && Objects.equals(this.launchUrl, ccLTILinkType.launchUrl) && Objects.equals(this.secureLaunchUrl, ccLTILinkType.secureLaunchUrl) && Objects.equals(this.icon, ccLTILinkType.icon) && Objects.equals(this.secureIcon, ccLTILinkType.secureIcon) && Objects.equals(this.vendor, ccLTILinkType.vendor) && Objects.equals(this.cartridgeBundle, ccLTILinkType.cartridgeBundle) && Objects.equals(this.cartridgeIcon, ccLTILinkType.cartridgeIcon) && Objects.equals(this.metadata, ccLTILinkType.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.custom, this.extensions, this.launchUrl, this.secureLaunchUrl, this.icon, this.secureIcon, this.vendor, this.cartridgeBundle, this.cartridgeIcon, this.metadata);
    }

    public String toString() {
        String sb = "class CCLTILinkType {\n    title: " + this.toIndentedString((Object)this.title) + "\n    description: " + this.toIndentedString((Object)this.description) + "\n    custom: " + this.toIndentedString((Object)this.custom) + "\n    extensions: " + this.toIndentedString((Object)this.extensions) + "\n    launchUrl: " + this.toIndentedString((Object)this.launchUrl) + "\n    secureLaunchUrl: " + this.toIndentedString((Object)this.secureLaunchUrl) + "\n    icon: " + this.toIndentedString((Object)this.icon) + "\n    secureIcon: " + this.toIndentedString((Object)this.secureIcon) + "\n    vendor: " + this.toIndentedString((Object)this.vendor) + "\n    cartridgeBundle: " + this.toIndentedString((Object)this.cartridgeBundle) + "\n    cartridgeIcon: " + this.toIndentedString((Object)this.cartridgeIcon) + "\n    metadata: " + this.toIndentedString((Object)this.metadata) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

