/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.CurriculumStandardsMetadataType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This is the is the container for the set of curriculum standards metadata. Each member of the set contains the curriculum standards metadata for a specific source of the GUIDs.")
public class CSMSetType
implements Serializable {
    @JsonProperty(value="resourceLabel")
    private String resourceLabel;
    @JsonProperty(value="resourcePartId")
    private String resourcePartId;
    @JsonProperty(value="curriculumStandardsMetadata")
    @Valid
    private List<CurriculumStandardsMetadataType> curriculumStandardsMetadata = new ArrayList();

    public CSMSetType resourceLabel(String resourceLabel) {
        this.resourceLabel = resourceLabel;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. This is a human readable label used to identify the type of resource, or part of resource, to which the enclosed metadata refers.")
    public String getResourceLabel() {
        return this.resourceLabel;
    }

    public void setResourceLabel(String resourceLabel) {
        this.resourceLabel = resourceLabel;
    }

    public CSMSetType resourcePartId(String resourcePartId) {
        this.resourcePartId = resourcePartId;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. This is used to contain the appropriate identifier that is used to identify the resource part.")
    public String getResourcePartId() {
        return this.resourcePartId;
    }

    public void setResourcePartId(String resourcePartId) {
        this.resourcePartId = resourcePartId;
    }

    public CSMSetType curriculumStandardsMetadata(List<CurriculumStandardsMetadataType> curriculumStandardsMetadata) {
        this.curriculumStandardsMetadata = curriculumStandardsMetadata;
        return this;
    }

    public CSMSetType addCurriculumStandardsMetadataItem(CurriculumStandardsMetadataType curriculumStandardsMetadataItem) {
        this.curriculumStandardsMetadata.add(curriculumStandardsMetadataItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The curriculum standards associated from a single source of the curriculum standards definition.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<CurriculumStandardsMetadataType> getCurriculumStandardsMetadata() {
        return this.curriculumStandardsMetadata;
    }

    public void setCurriculumStandardsMetadata(List<CurriculumStandardsMetadataType> curriculumStandardsMetadata) {
        this.curriculumStandardsMetadata = curriculumStandardsMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSMSetType csMSetType = (CSMSetType)o;
        return Objects.equals(this.resourceLabel, csMSetType.resourceLabel) && Objects.equals(this.resourcePartId, csMSetType.resourcePartId) && Objects.equals(this.curriculumStandardsMetadata, csMSetType.curriculumStandardsMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.resourceLabel, this.resourcePartId, this.curriculumStandardsMetadata);
    }

    public String toString() {
        String sb = "class CSMSetType {\n    resourceLabel: " + this.toIndentedString((Object)this.resourceLabel) + "\n    resourcePartId: " + this.toIndentedString((Object)this.resourcePartId) + "\n    curriculumStandardsMetadata: " + this.toIndentedString((Object)this.curriculumStandardsMetadata) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

