/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.SetOfGUIDsType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This is the container for the special metadata for curriculum standards for a particular domain of GUID provider.")
public class CurriculumStandardsMetadataType
implements Serializable {
    @JsonProperty(value="providerId")
    private String providerId;
    @JsonProperty(value="setOfGUIDs")
    @Valid
    private List<SetOfGUIDsType> setOfGUIDs = new ArrayList();

    public CurriculumStandardsMetadataType providerId(String providerId) {
        this.providerId = providerId;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. This is used to denote the originator of the GUID scheme.")
    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public CurriculumStandardsMetadataType setOfGUIDs(List<SetOfGUIDsType> setOfGUIDs) {
        this.setOfGUIDs = setOfGUIDs;
        return this;
    }

    public CurriculumStandardsMetadataType addSetOfGUIDsItem(SetOfGUIDsType setOfGUIDsItem) {
        this.setOfGUIDs.add(setOfGUIDsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The set of curriculum standards GUIDs that apply to the learning associated resource.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<SetOfGUIDsType> getSetOfGUIDs() {
        return this.setOfGUIDs;
    }

    public void setSetOfGUIDs(List<SetOfGUIDsType> setOfGUIDs) {
        this.setOfGUIDs = setOfGUIDs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurriculumStandardsMetadataType curriculumStandardsMetadataType = (CurriculumStandardsMetadataType)o;
        return Objects.equals(this.providerId, curriculumStandardsMetadataType.providerId) && Objects.equals(this.setOfGUIDs, curriculumStandardsMetadataType.setOfGUIDs);
    }

    public int hashCode() {
        return Objects.hash(this.providerId, this.setOfGUIDs);
    }

    public String toString() {
        String sb = "class CurriculumStandardsMetadataType {\n    providerId: " + this.toIndentedString((Object)this.providerId) + "\n    setOfGUIDs: " + this.toIndentedString((Object)this.setOfGUIDs) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

