/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.PlatformPropertySetType;
import de.mahlsdorf.lti13rs.ltirs.model.PropertySetType;
import de.mahlsdorf.lti13rs.ltirs.model.VendorType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="The container for all of the core information about an LTI Link. ")
public class LTILinkType
implements Serializable {
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="custom")
    private PropertySetType custom;
    @JsonProperty(value="extensions")
    private PlatformPropertySetType extensions;
    @JsonProperty(value="launch_url")
    private URI launchUrl;
    @JsonProperty(value="secure_launch_url")
    private URI secureLaunchUrl;
    @JsonProperty(value="icon")
    private URI icon;
    @JsonProperty(value="secure_icon")
    private URI secureIcon;
    @JsonProperty(value="vendor")
    private VendorType vendor;

    public LTILinkType title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. The human readable title/label for the activity being addressed by the content available through the LTI link.")
    @NotNull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LTILinkType description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = String. A human readable description of the activity addressed by the content supplied via the LTI link.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LTILinkType custom(PropertySetType custom) {
        this.custom = custom;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public PropertySetType getCustom() {
        return this.custom;
    }

    public void setCustom(PropertySetType custom) {
        this.custom = custom;
    }

    public LTILinkType extensions(PlatformPropertySetType extensions) {
        this.extensions = extensions;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public PlatformPropertySetType getExtensions() {
        return this.extensions;
    }

    public void setExtensions(PlatformPropertySetType extensions) {
        this.extensions = extensions;
    }

    public LTILinkType launchUrl(URI launchUrl) {
        this.launchUrl = launchUrl;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. The URL for the LTI launch. One of either the launch_url or the secure_launch_url must be specified. It is acceptable to specify both and if both are specified, the Tool Consumer (TC) decides which to use. Typically, the TC will use a secure_launch_url when embedding the Tool in a secure page and the launch_url when embedding the tool in a non-secure page. So, it is important that the Tool Provider (TP) provides the same functionality whether the launch_url or secure_launch_url is used.")
    @Valid
    public URI getLaunchUrl() {
        return this.launchUrl;
    }

    public void setLaunchUrl(URI launchUrl) {
        this.launchUrl = launchUrl;
    }

    public LTILinkType secureLaunchUrl(URI secureLaunchUrl) {
        this.secureLaunchUrl = secureLaunchUrl;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. A secure URL for the LTI launch. One of either the launch_url or the secure_launch_url must be specified. It is acceptable to specify both and if both are specified, the Tool Consumer (TC) decides which to use. Typically, the TC will use a secure_launch_url when embedding the Tool in a secure page and the launch_url when embedding the tool in a non-secure page. So, it is important that the Tool Provider (TP) provides the same functionality whether the launch_url or secure_launch_url is used.")
    @Valid
    public URI getSecureLaunchUrl() {
        return this.secureLaunchUrl;
    }

    public void setSecureLaunchUrl(URI secureLaunchUrl) {
        this.secureLaunchUrl = secureLaunchUrl;
    }

    public LTILinkType icon(URI icon) {
        this.icon = icon;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. A URL to an icon for this tool.")
    @Valid
    public URI getIcon() {
        return this.icon;
    }

    public void setIcon(URI icon) {
        this.icon = icon;
    }

    public LTILinkType secureIcon(URI secureIcon) {
        this.secureIcon = secureIcon;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. A secure URL to an icon for this tool.")
    @Valid
    public URI getSecureIcon() {
        return this.secureIcon;
    }

    public void setSecureIcon(URI secureIcon) {
        this.secureIcon = secureIcon;
    }

    public LTILinkType vendor(VendorType vendor) {
        this.vendor = vendor;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    public VendorType getVendor() {
        return this.vendor;
    }

    public void setVendor(VendorType vendor) {
        this.vendor = vendor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LTILinkType ltILinkType = (LTILinkType)o;
        return Objects.equals(this.title, ltILinkType.title) && Objects.equals(this.description, ltILinkType.description) && Objects.equals(this.custom, ltILinkType.custom) && Objects.equals(this.extensions, ltILinkType.extensions) && Objects.equals(this.launchUrl, ltILinkType.launchUrl) && Objects.equals(this.secureLaunchUrl, ltILinkType.secureLaunchUrl) && Objects.equals(this.icon, ltILinkType.icon) && Objects.equals(this.secureIcon, ltILinkType.secureIcon) && Objects.equals(this.vendor, ltILinkType.vendor);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.custom, this.extensions, this.launchUrl, this.secureLaunchUrl, this.icon, this.secureIcon, this.vendor);
    }

    public String toString() {
        String sb = "class LTILinkType {\n    title: " + this.toIndentedString((Object)this.title) + "\n    description: " + this.toIndentedString((Object)this.description) + "\n    custom: " + this.toIndentedString((Object)this.custom) + "\n    extensions: " + this.toIndentedString((Object)this.extensions) + "\n    launchUrl: " + this.toIndentedString((Object)this.launchUrl) + "\n    secureLaunchUrl: " + this.toIndentedString((Object)this.secureLaunchUrl) + "\n    icon: " + this.toIndentedString((Object)this.icon) + "\n    secureIcon: " + this.toIndentedString((Object)this.secureIcon) + "\n    vendor: " + this.toIndentedString((Object)this.vendor) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

