/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="The labelled curriculum standard GUID.")
public class LabelledGUIDType
implements Serializable {
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="caseItemURI")
    private URI caseItemURI;
    @JsonProperty(value="GUID")
    private String GUID;

    public LabelledGUIDType label(String label) {
        this.label = label;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. A human readable string to provide a clue about the nature of the curriculum standard.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public LabelledGUIDType caseItemURI(URI caseItemURI) {
        this.caseItemURI = caseItemURI;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. The corresponding Competency and Academic Standards (CASE) URI. This is the URI used for alignment with the IMS CASE Service 1.0 specification [CASE, 17].")
    @Valid
    public URI getCaseItemURI() {
        return this.caseItemURI;
    }

    public void setCaseItemURI(URI caseItemURI) {
        this.caseItemURI = caseItemURI;
    }

    public LabelledGUIDType GUID(String GUID) {
        this.GUID = GUID;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. The GUID itself.")
    @NotNull
    public String getGUID() {
        return this.GUID;
    }

    public void setGUID(String GUID) {
        this.GUID = GUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelledGUIDType labelledGUIDType = (LabelledGUIDType)o;
        return Objects.equals(this.label, labelledGUIDType.label) && Objects.equals(this.caseItemURI, labelledGUIDType.caseItemURI) && Objects.equals(this.GUID, labelledGUIDType.GUID);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.caseItemURI, this.GUID);
    }

    public String toString() {
        String sb = "class LabelledGUIDType {\n    label: " + this.toIndentedString((Object)this.label) + "\n    caseItemURI: " + this.toIndentedString((Object)this.caseItemURI) + "\n    GUID: " + this.toIndentedString((Object)this.GUID) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

