/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.LearningObjectivesType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="The container for the learning objectives which are addressed by the resource.")
public class LearningObjectivesType {
    @JsonProperty(value="alignmentType")
    private AlignmentTypeEnum alignmentType;
    @JsonProperty(value="educationalFramework")
    private String educationalFramework;
    @JsonProperty(value="targetDescription")
    private String targetDescription;
    @JsonProperty(value="targetName")
    private String targetName;
    @JsonProperty(value="targetURL")
    private URI targetURL;
    @JsonProperty(value="caseItemUri")
    private URI caseItemUri;
    @JsonProperty(value="caseItemGUID")
    private String caseItemGUID;

    public LearningObjectivesType alignmentType(AlignmentTypeEnum alignmentType) {
        this.alignmentType = alignmentType;
        return this;
    }

    @ApiModelProperty(required=true, value="A category of alignment between the learning resource and the framework node.")
    @NotNull
    public AlignmentTypeEnum getAlignmentType() {
        return this.alignmentType;
    }

    public void setAlignmentType(AlignmentTypeEnum alignmentType) {
        this.alignmentType = alignmentType;
    }

    public LearningObjectivesType educationalFramework(String educationalFramework) {
        this.educationalFramework = educationalFramework;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. The framework to which the resource being described is aligned.")
    public String getEducationalFramework() {
        return this.educationalFramework;
    }

    public void setEducationalFramework(String educationalFramework) {
        this.educationalFramework = educationalFramework;
    }

    public LearningObjectivesType targetDescription(String targetDescription) {
        this.targetDescription = targetDescription;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. The description of a node in an established educational framework.")
    public String getTargetDescription() {
        return this.targetDescription;
    }

    public void setTargetDescription(String targetDescription) {
        this.targetDescription = targetDescription;
    }

    public LearningObjectivesType targetName(String targetName) {
        this.targetName = targetName;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. The name of a node in an established educational framework.")
    public String getTargetName() {
        return this.targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public LearningObjectivesType targetURL(URI targetURL) {
        this.targetURL = targetURL;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. The URL of a node in an established educational framework.")
    @Valid
    public URI getTargetURL() {
        return this.targetURL;
    }

    public void setTargetURL(URI targetURL) {
        this.targetURL = targetURL;
    }

    public LearningObjectivesType caseItemUri(URI caseItemUri) {
        this.caseItemUri = caseItemUri;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. Reference to a CASE CFItem for a standard or skill [CASE, 17].")
    @Valid
    public URI getCaseItemUri() {
        return this.caseItemUri;
    }

    public void setCaseItemUri(URI caseItemUri) {
        this.caseItemUri = caseItemUri;
    }

    public LearningObjectivesType caseItemGUID(String caseItemGUID) {
        this.caseItemGUID = caseItemGUID;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. Reference to CASE CFItem as a GUID [CASE, 17].")
    public String getCaseItemGUID() {
        return this.caseItemGUID;
    }

    public void setCaseItemGUID(String caseItemGUID) {
        this.caseItemGUID = caseItemGUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LearningObjectivesType learningObjectivesType = (LearningObjectivesType)o;
        return Objects.equals(this.alignmentType, learningObjectivesType.alignmentType) && Objects.equals(this.educationalFramework, learningObjectivesType.educationalFramework) && Objects.equals(this.targetDescription, learningObjectivesType.targetDescription) && Objects.equals(this.targetName, learningObjectivesType.targetName) && Objects.equals(this.targetURL, learningObjectivesType.targetURL) && Objects.equals(this.caseItemUri, learningObjectivesType.caseItemUri) && Objects.equals(this.caseItemGUID, learningObjectivesType.caseItemGUID);
    }

    public int hashCode() {
        return Objects.hash(this.alignmentType, this.educationalFramework, this.targetDescription, this.targetName, this.targetURL, this.caseItemUri, this.caseItemGUID);
    }

    public String toString() {
        String sb = "class LearningObjectivesType {\n    alignmentType: " + this.toIndentedString((Object)this.alignmentType) + "\n    educationalFramework: " + this.toIndentedString((Object)this.educationalFramework) + "\n    targetDescription: " + this.toIndentedString((Object)this.targetDescription) + "\n    targetName: " + this.toIndentedString((Object)this.targetName) + "\n    targetURL: " + this.toIndentedString((Object)this.targetURL) + "\n    caseItemUri: " + this.toIndentedString((Object)this.caseItemUri) + "\n    caseItemGUID: " + this.toIndentedString((Object)this.caseItemGUID) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

