/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.PropertyType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The container for the collection of properties that are available for a specific platform.")
public class PlatformPropertySetType
implements Serializable {
    @JsonProperty(value="platform")
    private String platform;
    @JsonProperty(value="properties")
    @Valid
    private List<PropertyType> properties = new ArrayList();

    public PlatformPropertySetType platform(String platform) {
        this.platform = platform;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. The identifier for the authoring environment.")
    @NotNull
    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public PlatformPropertySetType properties(List<PropertyType> properties) {
        this.properties = properties;
        return this;
    }

    public PlatformPropertySetType addPropertiesItem(PropertyType propertiesItem) {
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The set of extension properties for the identified platform.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<PropertyType> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyType> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlatformPropertySetType platformPropertySetType = (PlatformPropertySetType)o;
        return Objects.equals(this.platform, platformPropertySetType.platform) && Objects.equals(this.properties, platformPropertySetType.properties);
    }

    public int hashCode() {
        return Objects.hash(this.platform, this.properties);
    }

    public String toString() {
        String sb = "class PlatformPropertySetType {\n    platform: " + this.toIndentedString((Object)this.platform) + "\n    properties: " + this.toIndentedString((Object)this.properties) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

