/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.PropertyType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The container for the collection of properties that have been specified.")
public class PropertySetType
implements Serializable {
    @JsonProperty(value="properties")
    @Valid
    private List<PropertyType> properties = new ArrayList();

    public PropertySetType properties(List<PropertyType> properties) {
        this.properties = properties;
        return this;
    }

    public PropertySetType addPropertiesItem(PropertyType propertiesItem) {
        this.properties.add(propertiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The set of properties for the identified platform or orginal authoring platform.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<PropertyType> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyType> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertySetType propertySetType = (PropertySetType)o;
        return Objects.equals(this.properties, propertySetType.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        String sb = "class PropertySetType {\n    properties: " + this.toIndentedString((Object)this.properties) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

