/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.ResourceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The container for the set of resources that have been supplied by the service provider. This may be empty if none of the resources fulfill the search criteria. The order of resources is not significant.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ResourceSetType
implements Serializable {
    @JsonProperty(value="resources")
    @Valid
    private List<ResourceType> resources = null;

    public ResourceSetType resources(List<ResourceType> resources) {
        this.resources = resources;
        return this;
    }

    public ResourceSetType addResourcesItem(ResourceType resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @ApiModelProperty(value="The actual resources supplied by the service provider. The order of resources is not significant.")
    @Valid
    @Size(min=0)
    public @Valid @Size(min=0) List<ResourceType> getResources() {
        return this.resources;
    }

    public void setResources(List<ResourceType> resources) {
        this.resources = resources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceSetType resourceSetType = (ResourceSetType)o;
        return Objects.equals(this.resources, resourceSetType.resources);
    }

    public int hashCode() {
        return Objects.hash(this.resources);
    }

    public String toString() {
        String sb = "class ResourceSetType {\n    resources: " + this.toIndentedString((Object)this.resources) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

