/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.CCLTILinkType;
import de.mahlsdorf.lti13rs.ltirs.model.LearningObjectivesType;
import de.mahlsdorf.lti13rs.ltirs.model.ResourceType;
import de.mahlsdorf.lti13rs.ltirs.model.TextComplexityType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.net.URI;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.format.annotation.DateTimeFormat;

@ApiModel(description="The container for the information about a resource that is supported by a LOR.")
public class ResourceType
implements Serializable {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="subject")
    @Valid
    private List<String> subject = null;
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="ltiLink")
    private CCLTILinkType ltiLink = null;
    @JsonProperty(value="learningResourceType")
    @Valid
    private List<String> learningResourceTypeList = new ArrayList();
    @JsonProperty(value="language")
    @Valid
    private List<String> language = null;
    @JsonProperty(value="thumbnailUrl")
    private URI thumbnailUrl;
    @JsonProperty(value="typicalAgeRange")
    private String typicalAgeRange;
    @JsonProperty(value="textComplexity")
    @Valid
    private List<TextComplexityType> textComplexity = null;
    @JsonProperty(value="learningObjectives")
    @Valid
    private List<LearningObjectivesType> learningObjectives = null;
    @JsonProperty(value="author")
    @Valid
    private List<String> author = null;
    @JsonProperty(value="publisher")
    private String publisher;
    @JsonProperty(value="useRightsURL")
    private URI useRightsURL;
    @JsonProperty(value="timeRequired")
    private String timeRequired;
    @JsonProperty(value="technicalFormat")
    private String technicalFormat;
    @JsonProperty(value="educationalAudience")
    @Valid
    private List<Object> educationalAudience = null;
    @JsonProperty(value="accessibilityAPI")
    @Valid
    private List<Object> accessibilityAPI = null;
    @JsonProperty(value="accessibilityInputMethods")
    @Valid
    private List<Object> accessibilityInputMethods = null;
    @JsonProperty(value="accessibilityFeatures")
    @Valid
    private List<String> accessibilityFeatures = null;
    @JsonProperty(value="accessibilityHazards")
    @Valid
    private List<Object> accessibilityHazards = null;
    @JsonProperty(value="accessMode")
    @Valid
    private List<Object> accessMode = null;
    @JsonProperty(value="publishDate")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE)
    private LocalDate publishDate;
    @JsonProperty(value="rating")
    private RatingEnum rating;
    @JsonProperty(value="relevance")
    private Float relevance;

    public ResourceType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. The name/title of resource.")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceType description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. A human readable description of the contents of the resource.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceType subject(List<String> subject) {
        this.subject = subject;
        return this;
    }

    public ResourceType addSubjectItem(String subjectItem) {
        if (this.subject == null) {
            this.subject = new ArrayList();
        }
        this.subject.add(subjectItem);
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. The subject(s) of the resource. May have multiple subjects tagged.")
    @Size(min=0)
    public @Size(min=0) List<String> getSubject() {
        return this.subject;
    }

    public void setSubject(List<String> subject) {
        this.subject = subject;
    }

    public ResourceType url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. How to access resource over Internet e.g. HTTP, FTP, etc. A resource must have either a URL or or a LTI Link.")
    @Valid
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public ResourceType ltiLink(CCLTILinkType ltiLink) {
        this.ltiLink = ltiLink;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public CCLTILinkType getLtiLink() {
        return this.ltiLink;
    }

    public void setLtiLink(CCLTILinkType ltiLink) {
        this.ltiLink = ltiLink;
    }

    public ResourceType learningResourceType(List<String> learningResourceType) {
        this.learningResourceTypeList = learningResourceType;
        return this;
    }

    public ResourceType addLearningResourceTypeItem(String learningResourceTypeItem) {
        this.learningResourceTypeList.add(learningResourceTypeItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The type of the resource. There may be multiple types.")
    @NotNull
    @Size(min=1)
    public @NotNull @Size(min=1) List<String> getLearningResourceTypeList() {
        return this.learningResourceTypeList;
    }

    public void setLearningResourceTypeList(List<String> learningResourceTypeList) {
        this.learningResourceTypeList = learningResourceTypeList;
    }

    public ResourceType language(List<String> language) {
        this.language = language;
        return this;
    }

    public ResourceType addLanguageItem(String languageItem) {
        if (this.language == null) {
            this.language = new ArrayList();
        }
        this.language.add(languageItem);
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = Language. The languages used in the resource. International two digit code for language e.g. 'en' for English. Use the [RFC 3066] annotation.")
    @Size(min=0)
    public @Size(min=0) List<String> getLanguage() {
        return this.language;
    }

    public void setLanguage(List<String> language) {
        this.language = language;
    }

    public ResourceType thumbnailUrl(URI thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. Link to a thumbnail representing resource.")
    @Valid
    public URI getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(URI thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public ResourceType typicalAgeRange(String typicalAgeRange) {
        this.typicalAgeRange = typicalAgeRange;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. Age of the typical intended user. This is described as EITHER the minimum-maximum age range (the format is '11-12', '5-7', etc. with ONLY integers permitted) OR the age as a single integer e.g. '9'.")
    public String getTypicalAgeRange() {
        return this.typicalAgeRange;
    }

    public void setTypicalAgeRange(String typicalAgeRange) {
        this.typicalAgeRange = typicalAgeRange;
    }

    public ResourceType textComplexity(List<TextComplexityType> textComplexity) {
        this.textComplexity = textComplexity;
        return this;
    }

    public ResourceType addTextComplexityItem(TextComplexityType textComplexityItem) {
        if (this.textComplexity == null) {
            this.textComplexity = new ArrayList();
        }
        this.textComplexity.add(textComplexityItem);
        return this;
    }

    @ApiModelProperty(value="A number indicating text complexity based on number of established measures.")
    @Valid
    @Size(min=0)
    public @Valid @Size(min=0) List<TextComplexityType> getTextComplexity() {
        return this.textComplexity;
    }

    public void setTextComplexity(List<TextComplexityType> textComplexity) {
        this.textComplexity = textComplexity;
    }

    public ResourceType learningObjectives(List<LearningObjectivesType> learningObjectives) {
        this.learningObjectives = learningObjectives;
        return this;
    }

    public ResourceType addLearningObjectivesItem(LearningObjectivesType learningObjectivesItem) {
        if (this.learningObjectives == null) {
            this.learningObjectives = new ArrayList();
        }
        this.learningObjectives.add(learningObjectivesItem);
        return this;
    }

    @ApiModelProperty(value="The set of learning objectives addressed by the resource.")
    @Valid
    @Size(min=0)
    public @Valid @Size(min=0) List<LearningObjectivesType> getLearningObjectives() {
        return this.learningObjectives;
    }

    public void setLearningObjectives(List<LearningObjectivesType> learningObjectives) {
        this.learningObjectives = learningObjectives;
    }

    public ResourceType author(List<String> author) {
        this.author = author;
        return this;
    }

    public ResourceType addAuthorItem(String authorItem) {
        if (this.author == null) {
            this.author = new ArrayList();
        }
        this.author.add(authorItem);
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. Author or creator of the resource.")
    @Size(min=0)
    public @Size(min=0) List<String> getAuthor() {
        return this.author;
    }

    public void setAuthor(List<String> author) {
        this.author = author;
    }

    public ResourceType publisher(String publisher) {
        this.publisher = publisher;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. Owner of the rights to the resource or who made it available (company or person).")
    @NotNull
    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public ResourceType useRightsURL(URI useRightsURL) {
        this.useRightsURL = useRightsURL;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. URL describing how resource can be licensed. Could be Creative Commons license link or link to other specific open or proprietary license.")
    @Valid
    public URI getUseRightsURL() {
        return this.useRightsURL;
    }

    public void setUseRightsURL(URI useRightsURL) {
        this.useRightsURL = useRightsURL;
    }

    public ResourceType timeRequired(String timeRequired) {
        this.timeRequired = timeRequired;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = Duration. Time that the resource takes to consume. Use the [ISO 8601] format for a duration.")
    public String getTimeRequired() {
        return this.timeRequired;
    }

    public void setTimeRequired(String timeRequired) {
        this.timeRequired = timeRequired;
    }

    public ResourceType technicalFormat(String technicalFormat) {
        this.technicalFormat = technicalFormat;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. A valid MIME type format for the resource e.g. text, HTML, PDF, MPEG, MP3, etc. See https://www.iana.org/assignments/media-types/media-types.xhtml.")
    public String getTechnicalFormat() {
        return this.technicalFormat;
    }

    public void setTechnicalFormat(String technicalFormat) {
        this.technicalFormat = technicalFormat;
    }

    public ResourceType educationalAudience(List<Object> educationalAudience) {
        this.educationalAudience = educationalAudience;
        return this;
    }

    public ResourceType addEducationalAudienceItem(Object educationalAudienceItem) {
        if (this.educationalAudience == null) {
            this.educationalAudience = new ArrayList();
        }
        this.educationalAudience.add(educationalAudienceItem);
        return this;
    }

    @ApiModelProperty(value="For whom the resource is intended.")
    @Size(min=0)
    public @Size(min=0) List<Object> getEducationalAudience() {
        return this.educationalAudience;
    }

    public void setEducationalAudience(List<Object> educationalAudience) {
        this.educationalAudience = educationalAudience;
    }

    public ResourceType accessibilityAPI(List<Object> accessibilityAPI) {
        this.accessibilityAPI = accessibilityAPI;
        return this;
    }

    public ResourceType addAccessibilityAPIItem(Object accessibilityAPIItem) {
        if (this.accessibilityAPI == null) {
            this.accessibilityAPI = new ArrayList();
        }
        this.accessibilityAPI.add(accessibilityAPIItem);
        return this;
    }

    @ApiModelProperty(value="Which (if any) accessibility API is supported by the resource.")
    @Size(min=0)
    public @Size(min=0) List<Object> getAccessibilityAPI() {
        return this.accessibilityAPI;
    }

    public void setAccessibilityAPI(List<Object> accessibilityAPI) {
        this.accessibilityAPI = accessibilityAPI;
    }

    public ResourceType accessibilityInputMethods(List<Object> accessibilityInputMethods) {
        this.accessibilityInputMethods = accessibilityInputMethods;
        return this;
    }

    public ResourceType addAccessibilityInputMethodsItem(Object accessibilityInputMethodsItem) {
        if (this.accessibilityInputMethods == null) {
            this.accessibilityInputMethods = new ArrayList();
        }
        this.accessibilityInputMethods.add(accessibilityInputMethodsItem);
        return this;
    }

    @ApiModelProperty(value="How the resource can be controlled by the user, which includes full keyboard controllability, mouse controllability, and voice controllability.")
    @Size(min=0)
    public @Size(min=0) List<Object> getAccessibilityInputMethods() {
        return this.accessibilityInputMethods;
    }

    public void setAccessibilityInputMethods(List<Object> accessibilityInputMethods) {
        this.accessibilityInputMethods = accessibilityInputMethods;
    }

    public ResourceType accessibilityFeatures(List<String> accessibilityFeatures) {
        this.accessibilityFeatures = accessibilityFeatures;
        return this;
    }

    public ResourceType addAccessibilityFeaturesItem(String accessibilityFeaturesItem) {
        if (this.accessibilityFeatures == null) {
            this.accessibilityFeatures = new ArrayList();
        }
        this.accessibilityFeatures.add(accessibilityFeaturesItem);
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. These include alternatives and listed enhancements for the resource. These can be transformation features, navigation features, control features or augmentation features.")
    @Size(min=0)
    public @Size(min=0) List<String> getAccessibilityFeatures() {
        return this.accessibilityFeatures;
    }

    public void setAccessibilityFeatures(List<String> accessibilityFeatures) {
        this.accessibilityFeatures = accessibilityFeatures;
    }

    public ResourceType accessibilityHazards(List<Object> accessibilityHazards) {
        this.accessibilityHazards = accessibilityHazards;
        return this;
    }

    public ResourceType addAccessibilityHazardsItem(Object accessibilityHazardsItem) {
        if (this.accessibilityHazards == null) {
            this.accessibilityHazards = new ArrayList();
        }
        this.accessibilityHazards.add(accessibilityHazardsItem);
        return this;
    }

    @ApiModelProperty(value="The set of accessibility hazards which are encountered when using this resource.")
    @Size(min=0)
    public @Size(min=0) List<Object> getAccessibilityHazards() {
        return this.accessibilityHazards;
    }

    public void setAccessibilityHazards(List<Object> accessibilityHazards) {
        this.accessibilityHazards = accessibilityHazards;
    }

    public ResourceType accessMode(List<Object> accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public ResourceType addAccessModeItem(Object accessModeItem) {
        if (this.accessMode == null) {
            this.accessMode = new ArrayList();
        }
        this.accessMode.add(accessModeItem);
        return this;
    }

    @ApiModelProperty(value="The human sensory perceptual system or cognitive faculty through which a person may process or perceive information.")
    @Size(min=0)
    public @Size(min=0) List<Object> getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(List<Object> accessMode) {
        this.accessMode = accessMode;
    }

    public ResourceType publishDate(LocalDate publishDate) {
        this.publishDate = publishDate;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = Date. Date the resource was published by the publisher. The 'date' using the [ISO 8601] format.")
    @Valid
    public LocalDate getPublishDate() {
        return this.publishDate;
    }

    public void setPublishDate(LocalDate publishDate) {
        this.publishDate = publishDate;
    }

    public ResourceType rating(RatingEnum rating) {
        this.rating = rating;
        return this;
    }

    @ApiModelProperty(value="A rating of the quality of the resource determined by the Search Provider. Often derived from crowdsource ratings.")
    public RatingEnum getRating() {
        return this.rating;
    }

    public void setRating(RatingEnum rating) {
        this.rating = rating;
    }

    public ResourceType relevance(Float relevance) {
        this.relevance = relevance;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = Float. This is a floating point value based on relevance to the specific search. Higher relevance has a higher number.")
    public Float getRelevance() {
        return this.relevance;
    }

    public void setRelevance(Float relevance) {
        this.relevance = relevance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceType resourceType = (ResourceType)o;
        return Objects.equals(this.name, resourceType.name) && Objects.equals(this.description, resourceType.description) && Objects.equals(this.subject, resourceType.subject) && Objects.equals(this.url, resourceType.url) && Objects.equals(this.ltiLink, resourceType.ltiLink) && Objects.equals(this.learningResourceTypeList, resourceType.learningResourceTypeList) && Objects.equals(this.language, resourceType.language) && Objects.equals(this.thumbnailUrl, resourceType.thumbnailUrl) && Objects.equals(this.typicalAgeRange, resourceType.typicalAgeRange) && Objects.equals(this.textComplexity, resourceType.textComplexity) && Objects.equals(this.learningObjectives, resourceType.learningObjectives) && Objects.equals(this.author, resourceType.author) && Objects.equals(this.publisher, resourceType.publisher) && Objects.equals(this.useRightsURL, resourceType.useRightsURL) && Objects.equals(this.timeRequired, resourceType.timeRequired) && Objects.equals(this.technicalFormat, resourceType.technicalFormat) && Objects.equals(this.educationalAudience, resourceType.educationalAudience) && Objects.equals(this.accessibilityAPI, resourceType.accessibilityAPI) && Objects.equals(this.accessibilityInputMethods, resourceType.accessibilityInputMethods) && Objects.equals(this.accessibilityFeatures, resourceType.accessibilityFeatures) && Objects.equals(this.accessibilityHazards, resourceType.accessibilityHazards) && Objects.equals(this.accessMode, resourceType.accessMode) && Objects.equals(this.publishDate, resourceType.publishDate) && Objects.equals(this.rating, resourceType.rating) && Objects.equals(this.relevance, resourceType.relevance);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.subject, this.url, this.ltiLink, this.learningResourceTypeList, this.language, this.thumbnailUrl, this.typicalAgeRange, this.textComplexity, this.learningObjectives, this.author, this.publisher, this.useRightsURL, this.timeRequired, this.technicalFormat, this.educationalAudience, this.accessibilityAPI, this.accessibilityInputMethods, this.accessibilityFeatures, this.accessibilityHazards, this.accessMode, this.publishDate, this.rating, this.relevance);
    }

    public String toString() {
        return "ResourceType{name='" + this.name + "', description='" + this.description + "', subject=" + this.subject + ", url='" + this.url + "', ltiLink=" + this.ltiLink + ", learningResourceTypeList=" + this.learningResourceTypeList + ", language=" + this.language + ", thumbnailUrl=" + this.thumbnailUrl + ", typicalAgeRange='" + this.typicalAgeRange + "', textComplexity=" + this.textComplexity + ", learningObjectives=" + this.learningObjectives + ", author=" + this.author + ", publisher='" + this.publisher + "', useRightsURL=" + this.useRightsURL + ", timeRequired='" + this.timeRequired + "', technicalFormat='" + this.technicalFormat + "', educationalAudience=" + this.educationalAudience + ", accessibilityAPI=" + this.accessibilityAPI + ", accessibilityInputMethods=" + this.accessibilityInputMethods + ", accessibilityFeatures=" + this.accessibilityFeatures + ", accessibilityHazards=" + this.accessibilityHazards + ", accessMode=" + this.accessMode + ", publishDate=" + this.publishDate + ", rating=" + this.rating + ", relevance=" + this.relevance + "}";
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

