/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.LabelledGUIDType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The  container for the set of GUIDs that annotate a resource for a particular geographical/socio-political/etc. region.")
public class SetOfGUIDsType
implements Serializable {
    @JsonProperty(value="region")
    private String region;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="labelledGUID")
    @Valid
    private List<LabelledGUIDType> labelledGUID = new ArrayList();

    public SetOfGUIDsType region(String region) {
        this.region = region;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. The region responsible for the definition. ")
    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public SetOfGUIDsType version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. This is used to denote any relevant versioning information.")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SetOfGUIDsType labelledGUID(List<LabelledGUIDType> labelledGUID) {
        this.labelledGUID = labelledGUID;
        return this;
    }

    public SetOfGUIDsType addLabelledGUIDItem(LabelledGUIDType labelledGUIDItem) {
        this.labelledGUID.add(labelledGUIDItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The actual GUID plus the corresponding labelling information.")
    @NotNull
    @Valid
    @Size(min=1)
    public @NotNull @Valid @Size(min=1) List<LabelledGUIDType> getLabelledGUID() {
        return this.labelledGUID;
    }

    public void setLabelledGUID(List<LabelledGUIDType> labelledGUID) {
        this.labelledGUID = labelledGUID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SetOfGUIDsType setOfGUIDsType = (SetOfGUIDsType)o;
        return Objects.equals(this.region, setOfGUIDsType.region) && Objects.equals(this.version, setOfGUIDsType.version) && Objects.equals(this.labelledGUID, setOfGUIDsType.labelledGUID);
    }

    public int hashCode() {
        return Objects.hash(this.region, this.version, this.labelledGUID);
    }

    public String toString() {
        String sb = "class SetOfGUIDsType {\n    region: " + this.toIndentedString((Object)this.region) + "\n    version: " + this.toIndentedString((Object)this.version) + "\n    labelledGUID: " + this.toIndentedString((Object)this.labelledGUID) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

