/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.mahlsdorf.lti13rs.ltirs.model.SubjectType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.Size;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="The container for the set of subjects that have been supplied by the service provider. This may be empty if none of the subjects fulfill the search criteria. The order of subjects is not significant.")
public class SubjectSetType
implements Serializable {
    @JsonProperty(value="subjects")
    @Valid
    private List<SubjectType> subjects = null;

    public SubjectSetType subjects(List<SubjectType> subjects) {
        this.subjects = subjects;
        return this;
    }

    public SubjectSetType addSubjectsItem(SubjectType subjectsItem) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        this.subjects.add(subjectsItem);
        return this;
    }

    @ApiModelProperty(value="The actual list of subject supplied by the service provider. The order of subjects is not significant.")
    @Valid
    @Size(min=0)
    public @Valid @Size(min=0) List<SubjectType> getSubjects() {
        return this.subjects;
    }

    public void setSubjects(List<SubjectType> subjects) {
        this.subjects = subjects;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectSetType subjectSetType = (SubjectSetType)o;
        return Objects.equals(this.subjects, subjectSetType.subjects);
    }

    public int hashCode() {
        return Objects.hash(this.subjects);
    }

    public String toString() {
        String sb = "class SubjectSetType {\n    subjects: " + this.toIndentedString((Object)this.subjects) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

