/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="This is the container for the details of a subject that is covered by the content within a LOR.")
public class SubjectType
implements Serializable {
    @JsonProperty(value="identifier")
    private Integer identifier;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="parent")
    private Integer parent;

    public SubjectType identifier(Integer identifier) {
        this.identifier = identifier;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = PositiveInteger. The unique identifier, an integer, of the subject node. For the root node the value will be 'null'. ")
    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) Integer getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Integer identifier) {
        this.identifier = identifier;
    }

    public SubjectType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. The name of the subject node, which may have any character and need not be unique with the returned taxonomy. ")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubjectType parent(Integer parent) {
        this.parent = parent;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = PositiveInteger. An integer (the identifier of that subject node) that references the single parent of this node. The returned data must be a true rooted tree, where each node returned has a single parent. ")
    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) Integer getParent() {
        return this.parent;
    }

    public void setParent(Integer parent) {
        this.parent = parent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubjectType subjectType = (SubjectType)o;
        return Objects.equals(this.identifier, subjectType.identifier) && Objects.equals(this.name, subjectType.name) && Objects.equals(this.parent, subjectType.parent);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.name, this.parent);
    }

    public String toString() {
        String sb = "class SubjectType {\n    identifier: " + this.toIndentedString((Object)this.identifier) + "\n    name: " + this.toIndentedString((Object)this.name) + "\n    parent: " + this.toIndentedString((Object)this.parent) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

