/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;

@ApiModel(description="The container for the information about the vendor who created the resource.")
public class VendorType
implements Serializable {
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="url")
    private URI url;
    @JsonProperty(value="emailContact")
    private String emailContact;

    public VendorType code(String code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. An identification code for the vendor.")
    @NotNull
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public VendorType name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Model Primitive Datatype = NormalizedString. The name of the vendor.")
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VendorType description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = String. A human readable description of the vendor.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public VendorType url(URI url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = AnyURI. A URL for the vendor.")
    @Valid
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public VendorType emailContact(String emailContact) {
        this.emailContact = emailContact;
        return this;
    }

    @ApiModelProperty(value="Model Primitive Datatype = NormalizedString. Contact email for the vendor.")
    public String getEmailContact() {
        return this.emailContact;
    }

    public void setEmailContact(String emailContact) {
        this.emailContact = emailContact;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VendorType vendorType = (VendorType)o;
        return Objects.equals(this.code, vendorType.code) && Objects.equals(this.name, vendorType.name) && Objects.equals(this.description, vendorType.description) && Objects.equals(this.url, vendorType.url) && Objects.equals(this.emailContact, vendorType.emailContact);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.name, this.description, this.url, this.emailContact);
    }

    public String toString() {
        String sb = "class VendorType {\n    code: " + this.toIndentedString((Object)this.code) + "\n    name: " + this.toIndentedString((Object)this.name) + "\n    description: " + this.toIndentedString((Object)this.description) + "\n    url: " + this.toIndentedString((Object)this.url) + "\n    emailContact: " + this.toIndentedString((Object)this.emailContact) + "\n}";
        return sb;
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

