/*
 * Decompiled with CFR 0.152.
 */
package de.mahlsdorf.lti13rs.ltirs.predicate;

import java.lang.reflect.Field;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericPredicate {
    private static final Logger logger = LoggerFactory.getLogger(GenericPredicate.class);

    public static <T> Predicate<T> filter(Class<T> clazz, String fieldName, String predicate, Object fieldValue) {
        return instance -> {
            try {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object valueToCompare = field.get(instance);
                String valueToCompareString = valueToCompare.toString();
                String predicateValue = fieldValue.toString();
                switch (predicate) {
                    case "=": {
                        boolean returnValue = fieldValue.equals(valueToCompare);
                        logger.info("Equals fieldValue {}  class {} Value {} returnValue {} ", new Object[]{fieldValue, fieldValue.getClass(), field.get(instance), returnValue});
                        return returnValue;
                    }
                    case "~": {
                        boolean returnValue = valueToCompareString.contains(predicateValue);
                        logger.info("Contains fieldValue {}  class {} Value {} returnValue {} ", new Object[]{fieldValue, fieldValue.getClass(), field.get(instance), returnValue});
                        return returnValue;
                    }
                }
                logger.error("No Predicate {} found", (Object)predicate);
                return false;
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                return false;
            }
        };
    }
}

