/**
<!--
  ~     Copyright (C) 2025  Alexander Becker
  ~
  ~     License:  GPL v3.0
  ~
  ~     This program is free software: you can redistribute it and/or modify it
  ~     under the terms of the GNU General
  ~     Public License as published by the Free Software Foundation, version 3.
  ~
  ~     This program is distributed in the hope that it will be useful,
  ~      but WITHOUT ANY WARRANTY; without even the
  ~      implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  ~      See the GNU General Public
  ~      License for more details.
  ~
  ~     You should have received a copy of the GNU General Public License along
  ~      with this program. If not, see
  ~      https://www.gnu.org/licenses/.
  ~
  ~
  -->
**/

function debugMsg(msg) {
 //console.log(msg)
}

function loadJSON(path, success, error) {
    var xhr = new XMLHttpRequest();
    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4) {
            if (xhr.status === 200) {
                success(JSON.parse(xhr.responseText));
            } else {
                error(xhr);
            }
        }
    };
    xhr.open('GET', path, true);
    xhr.send();
}

function loadJsonWithPost(path, body, success, error) {
    var xhr = new XMLHttpRequest();
    xhr.onreadystatechange = function () {
        if (xhr.readyState === 4) {
            if (xhr.status === 200) {
                success(JSON.parse(xhr.responseText));
            } else {
                error(xhr);
            }
        }
    };
    xhr.open('POST', path, true);
    xhr.setRequestHeader("Content-Type", "application/json");
    xhr.setRequestHeader("Accept", "application/json");
    xhr.send(body);
}


/**
 * try to load data from neo4j
 * enhance true   add to existing network   false create new network
 * type may be lg / course   (See backend)
 */
async function getNetworkFromNeo4j(teacherId,schoolId,type , getResultForVis,enhance,nodesMap,edgeMap,tempNodesMap,tempEdgeMap) {
   let cypher ='{ "teacherId": "'+teacherId+'", "schoolId":"'+schoolId+'"}';
    debugMsg("cypher \n" + cypher);
    let url = '/platformapi/v1/graph/'+type;
    if (getResultForVis) {
        let promiseLoad = new Promise((resolve, reject) => {
            loadJsonWithPost(url, cypher,
                function (json) {
                    let value = successLoadAndPrepareDataForVis(json,enhance,nodesMap,edgeMap,tempNodesMap,tempEdgeMap);
                    resolve(value);
                }, function (json) {
                    reject(errorLoad(json));
                })
        });
        return promiseLoad;
    } else {
        let promiseLoad = new Promise((resolve, reject) => {
            loadJsonWithPost(url, cypher,
                function (json) {
                    //let value = successLoadAndPrepareDataForVis(json);
                    resolve("nothing");
                }, function (json) {
                    reject(errorLoad(json));
                })
        });
        return promiseLoad;
    }


}

/**
 * after loading the data from neo4j , it will be converted into 2 Array with nodes and edges
 *
 *  depends strongly on the return json from NEO4j
 *
 * @param json
 * @returns {{nodes: [], edges: []}}
 */
function successLoadAndPrepareDataForVis(json,enhance,nodesMap,edgeMap,tempNodesMap,tempEdgeMap) {

    let nodesSet = new Set();
    let edgeSet = new Set();
    let labelMap = new Map();
    let nodes = [];
    let edges = [];


    //
    //if ( enhance) {
    //    nodes =network.body.data.nodes;
    //    edges =network.body.data.edges;
    //
    //}


    debugMsg('success Load ' + json);
    let data = json.results[0].data;
    let length = data.length;
    // list nodes and edges
    data.forEach(dataNode => {

        dataNode.graph.nodes.forEach(node => {
            //let node1 = dataNode.graph.nodes[0];
            pushNodeData(nodesSet, nodes, node, labelMap, nodesMap);
        });

        dataNode.graph.relationships.forEach(relNode => {
            if (!edgeSet.has(relNode.id)) {
                debugMsg('relation:' + relNode.id);
                let labelFrom = labelMap.get(relNode.startNode);
                let labelTo = labelMap.get(relNode.endNode);
                debugMsg("relation " + relNode.id + " startNode " + relNode.startNode + ":" + labelFrom
                    + " EndNode " + relNode.endNode + ":" + labelTo);
                let myEdge = {
                    id: relNode.id,
                    label: relNode.type,
                    from: relNode.startNode,
                    fromLabel: labelFrom,
                    to: relNode.endNode,
                    toLabel: labelTo
                };
                edges.push(myEdge);
                edgeSet.add(relNode.id)
                edgeMap.set(relNode.id, myEdge);
            }
        });
    });
    if (enhance) {
        debugMsg("nodesMap "+nodesMap+"  edgeMap "+edgeMap);
        AddNodesAndEdge(nodes,edges);
        for (const node of nodes) {
            try {
                addIfStudent(node, network.body.data.nodes)
            } catch (e) {
                // do nothing
            }
            nodesMap.set(node.id,node)
            // for removal of temp Nodes
            tempNodesMap.set(node.id,node);
        }
        for (const edge of edges) {
            edgeMap.set(edge.id,edge);
            // for removal of temp edges
            tempEdgeMap.set(edge.id,edge);
        }

        edgeMap = new Map();

    }
    return {nodes: nodes, edges: edges, nodesMap: nodesMap, edgeMap: edgeMap}
}

function AddNodesAndEdge(nodes,edges)
{
    for (const node of nodes) {
        addIfStudent(node,network.body.data.nodes)
    }
    network.body.data.edges.add(edges)

}

function addIfStudent(node,nodesFromNetwork) {
    if (node.studentId !== undefined)
    {
        nodesFromNetwork.add(node);
    }
}

function removeTempNodesAndEdges(nodesMap, edgeMap, tempNodesMap, tempEdgeMap) {
    tempNodesMap.forEach((_value, key) => {
        if (_value.studentId !== undefined) {
            network.body.data.nodes.remove(_value);
            try {
                nodesMap.delete(key);
            } catch (e) {
                // do nothing
            }
        }
    });
    tempEdgeMap.forEach((_value, key) => {
            network.body.data.edges.remove(_value);
            try {
                edgeMap.delete(key);
            } catch (e) {
                // do nothing
            }
        })
        tempEdgeMap.clear();
        tempNodesMap.clear();

}


/**
 * Handles a click in graph View
 * @param nodesMap
 * @param edgeMap
 * @param params
 * @param network
 */
function handleClickLoadNeighbors(nodesMap, edgeMap, tempNodesMap,tempEdgeMap,params, network) {
    params.event = "[original event]";
    document.getElementById("eventSpanHeading").innerText = "Click event:";
    document.getElementById("eventSpanContent").innerText = JSON.stringify(
        params,
        null,
        4
    );
    removeTempNodesAndEdges(nodesMap,edgeMap,tempNodesMap,tempEdgeMap);
    let myNodeIdList = null;
    if (params.nodes !== undefined) {
        myNodeIdList = params.nodes;
        debugMsg("Clicked Node " + myNodeIdList);
        selectedNode=nodesMap.get(myNodeIdList.at(0));
        debugMsg('NODE '+JSON.stringify(selectedNode));
    }
    if (selectedNode !== undefined && selectedNode.taskId !== undefined) {
        // nore get students
        //getStudentsForTask(selectedNode,nodesMap,edgeMap,tempNodesMap,tempEdgeMap)
        return;
    } else {
        debugMsg("no task selected Return ");
    }

    // temp unreachable
    // while loading students from neo4j
    // see getStudentsForTask
    let nodeArray = [];
    // get the nodes on the edges that are selected
    for (const edgeId of params.edges) {
        debugMsg("edgeId " + edgeId);
        let myEdge = edgeMap.get(edgeId);
        debugMsg(" Edge " + JSON.stringify(myEdge));
        if (myEdge !== undefined && myEdge !== null) {
            if (myEdge.from == myNodeIdList) {
                nodeArray.push(myEdge.to);
                debugMsg("otherNode " + myEdge.to);
            } else {
                nodeArray.push(myEdge.from);
                debugMsg("otherNode " + myEdge.from);
            }
        }

    }
    debugMsg(" other nodes to select " + JSON.stringify(nodeArray));
    network.selectNodes(nodeArray);
}

function getStudentsForTask(selectedNode, nodesMap,edgeMap,tempNodeMap,tempEdgeMap) {
    debugMsg("Student "+JSON.stringify(selectedNode))
    let taskId=selectedNode.taskId;
    let cypher="optional MATCH (ta:Task)-[sht:StudentHasTask]-(s:Student) where ta.taskId='"+taskId+"'   RETURN *\;"
    debugMsg("cypher for student is "+cypher);
    // TODO laedt das Netzwerk nur mit studenten
    let getResultForVis=true;
    getNetworkFromNeo4j(cypher, getResultForVis,true,nodesMap,edgeMap,tempNodesMap,tempEdgeMap);
    debugMsg(nodes);
    debugMsg(edges);
}

function getReadOnlyFields() {
    let readOnlyProperties = new Set(["label", "id", "type", "number", "uuid", "modified", "id"]);
    return readOnlyProperties;
}

/**
 * creates a dynamic form depending on the properties in
 * the node data
 * @param nodeData
 */
function createNodeForm(nodeData) {

    // some constants (properties not to display
    let notDiaplayableProperties = new Set(["title", "color", "imagePadding", "shape", "fixed", "font", "icon", "margin", "scaling", "shadow", "shapeProperties", "size", "x", "y"]);
    // properties readOnly
    let readOnlyProperties = getReadOnlyFields();


    // remove all from Dom in the format
    let upperFormNode = document.getElementById('upperFormNode');
    var child = upperFormNode.lastElementChild;
    while (child) {
        upperFormNode.removeChild(child);
        child = upperFormNode.lastElementChild;
    }

    //let br=document.createElement('br');
    for (let [key, value] of Object.entries(nodeData)) {
        if (!notDiaplayableProperties.has(key)) {
            let upperDiv = document.createElement('div');
            upperDiv.setAttribute('class', 'preference');
            let label = document.createElement('label');
            label.innerHTML = key;
            let input = document.createElement('input');
            input.setAttribute('type', 'text');
            input.setAttribute('value', "" + value);
            input.setAttribute('id', "" + key);
            if (readOnlyProperties.has(key)) {
                input.setAttribute('readonly', "true");
                input.setAttribute('class', "readOnly");
                input.setAttribute('style', "color:lightgrey");
            }
            upperDiv.append(label, input);
            upperFormNode.appendChild(upperDiv);
        }
    }

}

/**
 * creates a cypher statement and send ist to neo4j
 * @param upperFromNode
 *
 */
function saveNodeDataIntoNeo4j(upperFromNode) {
    let childNodes = upperFromNode.querySelectorAll('div');
    let labelString = '';
    let numberString = '';
    let setClause = '';
    // over all Divs
    childNodes.forEach(
        function (currentValue, currentIndex, listObj) {
            //debugMsg(currentValue + ', ' + currentIndex + ', ' + this);
            let readOnlyProperties = getReadOnlyFields();
            // oper all Input inside the div
            currentValue.querySelectorAll('input').forEach(function (currentValue, currentIndex, listObj) {
                debugMsg('input id ' + currentValue.id + ' value  ' + currentValue.value + " -->" + currentIndex + ', ' + this);
                let id = currentValue.id;
                let value = currentValue.value;
                // both following Values needed for the update Statement
                // but must not be updated
                if (id === "number") {
                    numberString = value;
                }
                if (id === "label") {
                    labelString = value;
                }

                // exclude readonly Properties from update
                if (!readOnlyProperties.has(id)) {

                    let isNumeric = false;
                    let matchArray = value.match("/([0-9\\.\\-]+)/g");
                    debugMsg("Value  " + value);
                    if (matchArray && matchArray[0] === value) {
                        isNumeric = true;
                        if (currentValue.id === "plz") {
                            // stored as String
                            isNumeric = false;
                        }
                    }
                    if (isNumeric) {
                        debugMsg("Value  " + value + "is numeric");
                        setClause += "n." + id + "=" + +value + ",";
                    } else {
                        setClause += "n." + id + "='" + value + "',";
                    }
                }
            });
        });

    let len = setClause.length - 1;
    setClause = setClause.substr(0, len);
    let cypherString = "Match ( n:" + labelString + " { number :" + numberString + "}) set " + setClause + " return n.number ";

    debugMsg("cypher " + cypherString);
    // aud der HTML Seite aufrufen und neu Zeichnen lassen
    return cypherString;

}

/**
 * builds the Data for a single node
 * contains different shapes for different lables (NEO4J Lables eg. Node Types)
 * @param nodesSet
 * @param nodes
 * @param nodeToWorkWith
 */
function pushNodeData(nodesSet, nodes, nodeToWorkWith, labelMap, nodeMap) {

    //let ident = nodeToWorkWith.labels[0] + ":" + nodeToWorkWith.id;
    let ident = nodeToWorkWith.id;
    if (nodesSet.has(ident)) {
        debugMsg("ident " + ident + " in den nodes bereits enthalten");
        return;
    }
    debugMsg("add Node " + nodeToWorkWith.id + " ident " + ident);

    let shapeMap = new Map();
    shapeMap.set("School", {shape: 'box', color: '#97C2FC'});
    shapeMap.set("Student", {shape: 'box', color: '#0e7af3'});
    shapeMap.set("Teacher", {shape: 'box', color: '#21bc3e'});
    shapeMap.set("LearningGroup", {shape: 'box', color: '#f7d263'});
    shapeMap.set("Course", {shape: 'box', color: '#5e88b8'});
    shapeMap.set("Task", {shape: 'box', color: '#e83d7d'});
    // special Properties of a node
    let p2 = nodeToWorkWith.properties;

    // Standard Elements
    let labelString = nodeToWorkWith.labels[0];
    labelMap.set(nodeToWorkWith.id, labelString);
    let myLabel = labelString;
    if (labelString === "Teacher") {
        myLabel = labelString + "\n" + p2.firstname + "\n" + p2.lastname;
    } else if (labelString === "Student") {
        myLabel = labelString + "\n" + p2.firstname + "\n" + p2.lastname;
    } else if (labelString === "Course") {
        myLabel = labelString + "\n" + p2.name;
    } else if (labelString === "LearningGroup") {
        myLabel = labelString + "\n" + p2.learngroupName;
    } else if (labelString === "Task") {
        if (p2.type === "headline") {
        // todo has to be checked (at the moment we show only till courses
        // headline should not be inserted
        return;
        }
        const abbr = str => str.match(/\b([A-Za-z0-9])/g).join('').toUpperCase()
        const result = abbr(p2.name)
        myLabel = labelString + "\n" + result;

    } else {
        myLabel = labelString;
    }

    let myNode = {id: nodeToWorkWith.id, type: "Label " + nodeToWorkWith.id, label: myLabel};

    // add all of the property
    let titleString = "";

    // building a titleobject // Hover
    if (labelString === "Task") {
          titleString=p2.name;
    }

    let titleObject = {"title": titleString};
    myNode = Object.assign(myNode, titleObject);
    myNode = Object.assign(myNode, p2);
    // type of the label
    let shapeObject = shapeMap.get(labelString);
    debugMsg(" " + Object.getOwnPropertyNames(shapeObject));
    myNode = Object.assign(myNode, shapeObject);
    // add this to the Node Array
    nodes.push(
        myNode
    );
    nodesSet.add(ident);
    nodeMap.set(ident, myNode);
}


function errorLoad(json) {
    debugMsg('error while loading cyper ' + cyperStatement);
}



var seededRandom = vis.util.Alea('SEED');

